/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.logcat;

import android.util.Log;
import cn.keayuan.util.log.PrintStrategy;
import cn.keayuan.util.log.Printer;

public class LogcatPrinter
extends Printer {
    private boolean isNew = true;
    private int maxLength = 3000;
    private static LogcatPrinter mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static LogcatPrinter getInstance(PrintStrategy strategy) {
        if (mInstance == null) {
            Class<LogcatPrinter> clazz = LogcatPrinter.class;
            // MONITORENTER : cn.keayuan.util.log.logcat.LogcatPrinter.class
            if (mInstance == null) {
                mInstance = new LogcatPrinter();
            }
            // MONITOREXIT : clazz
        }
        LogcatPrinter.mInstance.printStrategy = strategy;
        return mInstance;
    }

    private LogcatPrinter() {
    }

    public LogcatPrinter setNew(boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public void maxLength(int max) {
        this.maxLength = max;
    }

    @Override
    public void print(int priority, String tag, String message) {
        if (this.isNew) {
            while (message.length() > this.maxLength) {
                int index = message.lastIndexOf(NEW_LINE, this.maxLength);
                if (index < 0) {
                    index = this.maxLength - 1;
                }
                Log.println((int)priority, (String)tag, (String)message.substring(0, index));
                if (NEW_LINE.equals(message.substring(index, index + 1))) {
                    message = message.substring(index + 1);
                    continue;
                }
                message = message.substring(index);
            }
            Log.println((int)priority, (String)tag, (String)message);
        } else {
            String[] result;
            for (String msg : result = message.split(NEW_LINE)) {
                Log.println((int)priority, (String)tag, (String)msg);
            }
        }
    }
}

