/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.disk;

import cn.keayuan.util.log.PrintStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class DiskLogStrategy
implements PrintStrategy,
Runnable {
    private int mMaxFileSize = 0x100000;
    private String fileName = "log";
    private final String mPath;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();
    private Executor executor;
    private RandomAccessFile out;
    private volatile boolean isRunning;

    public DiskLogStrategy(String path) {
        this(path, 0);
    }

    public DiskLogStrategy(String path, int maxFile) {
        this.mPath = path;
        if (maxFile > this.mMaxFileSize) {
            this.mMaxFileSize = maxFile;
        }
    }

    public DiskLogStrategy fileName(String name) {
        this.fileName = name == null ? "name" : name;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean print(int level, String tag, String message) {
        this.queue.offer(tag + ":" + message);
        if (this.executor != null) return true;
        Class<DiskLogStrategy> clazz = DiskLogStrategy.class;
        synchronized (DiskLogStrategy.class) {
            this.executor = Executors.newSingleThreadExecutor();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (this.isRunning) return true;
            this.executor.execute(this);
            return true;
        }
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                String item = this.queue.take();
                if (this.out == null) {
                    this.out = this.getFileOutputStream(this.mPath, this.fileName);
                }
                this.out.write(item.getBytes());
                if (this.out.length() <= (long)this.mMaxFileSize) continue;
                this.out.close();
                this.out = null;
            }
            catch (FileNotFoundException | InterruptedException e) {
                e.printStackTrace();
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.isRunning = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private RandomAccessFile getFileOutputStream(String folderName, String fileName) throws FileNotFoundException {
        long length;
        File newFile;
        File folder = new File(folderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((newFile = new File(folder, fileName + ".log")).exists() && (length = newFile.length()) > (long)this.mMaxFileSize) {
            File temp;
            int newFileCount = 0;
            while ((temp = new File(folder, String.format("%s_%s.log", fileName, newFileCount++))).exists()) {
            }
            newFile.renameTo(temp);
            newFile = new File(folder, fileName + ".log");
        }
        return new RandomAccessFile(newFile, "rw");
    }
}

