/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.console;

import cn.keayuan.util.log.PrintStrategy;
import cn.keayuan.util.log.Printer;
import cn.keayuan.util.log.logcat.LogcatPrinter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ConsolePrinter
extends Printer {
    private final Date date = new Date();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private static ConsolePrinter mInstance;
    private boolean pretty = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ConsolePrinter getInstance(PrintStrategy format) {
        if (mInstance == null) {
            Class<LogcatPrinter> clazz = LogcatPrinter.class;
            // MONITORENTER : cn.keayuan.util.log.logcat.LogcatPrinter.class
            if (mInstance == null) {
                mInstance = new ConsolePrinter();
            }
            // MONITOREXIT : clazz
        }
        ConsolePrinter.mInstance.printStrategy = format;
        return mInstance;
    }

    private ConsolePrinter() {
    }

    public void enablePretty(boolean enable) {
        this.pretty = enable;
    }

    @Override
    protected String formatTag(int priority, String tag) {
        if (tag == null) {
            tag = "";
        }
        String type = "";
        String start = "";
        switch (priority) {
            case 2: {
                type = " V/";
                start = "\u001b[30;37m";
                break;
            }
            case 3: {
                type = " D/";
                start = "\u001b[30;34m";
                break;
            }
            case 4: {
                type = " I/";
                start = "\u001b[30;32m";
                break;
            }
            case 5: {
                type = " W/";
                start = "\u001b[30;33m";
                break;
            }
            case 6: {
                type = " E/";
                start = "\u001b[30;31m";
                break;
            }
        }
        if (!this.pretty) {
            start = "";
        }
        this.date.setTime(System.currentTimeMillis());
        return start + this.dateFormat.format(this.date) + " " + Thread.currentThread().getId() + type + tag + ": ";
    }

    @Override
    protected String format(String msg) {
        return this.pretty ? msg + "\u001b[0m" : msg;
    }

    @Override
    public void print(int priority, String tag, String message) {
        String[] result;
        for (String msg : result = message.split(NEW_LINE)) {
            System.out.println(tag + msg);
        }
    }
}

