/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import cn.keayuan.util.log.PrintStrategy;

public abstract class Printer {
    protected static final String NEW_LINE;
    protected PrintStrategy printStrategy;

    public Printer() {
    }

    public Printer(PrintStrategy strategy) {
        this.printStrategy = strategy;
    }

    final synchronized void log(int priority, String tag, String message) {
        if (this.printStrategy == null) {
            if (this.isLoggable(priority, tag)) {
                tag = this.formatTag(priority, tag);
                message = this.format(message);
                this.print(priority, tag, message);
            }
        } else {
            Object temp = this.printStrategy.isLoggable(priority, tag);
            if (temp == null ? this.isLoggable(priority, tag) : ((Boolean)temp).booleanValue()) {
                temp = this.printStrategy.formatTag(priority, tag);
                if (temp == null) {
                    temp = this.formatTag(priority, tag);
                }
                tag = String.valueOf(temp);
                temp = this.printStrategy.format(message);
                if (temp == null) {
                    temp = this.format(message);
                }
                if (!this.printStrategy.print(priority, tag, message = String.valueOf(temp))) {
                    this.print(priority, tag, message);
                }
            }
        }
    }

    protected boolean isLoggable(int priority, String tag) {
        return true;
    }

    protected String formatTag(int priority, String tag) {
        return tag;
    }

    protected String format(String msg) {
        return msg;
    }

    protected abstract void print(int var1, String var2, String var3);

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    static {
        String line = System.getProperty("line.separator");
        NEW_LINE = line == null ? "\n" : line;
    }
}

