package cn.keayuan.util.log.logcat;

import android.util.Log;

import cn.keayuan.util.log.PrintStrategy;
import cn.keayuan.util.log.Printer;

public class LogcatPrinter extends Printer {

    private boolean isNew = true;
    private int maxLength = 3000;

    private static LogcatPrinter mInstance;

    public static LogcatPrinter getInstance(PrintStrategy strategy) {
        if (mInstance == null) {
            synchronized (LogcatPrinter.class) {
                if (mInstance == null) {
                    mInstance = new LogcatPrinter();
                }
            }
        }
        mInstance.printStrategy = strategy;
        return mInstance;
    }

    private LogcatPrinter() {
    }

    public LogcatPrinter setNew(boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public void maxLength(int max) {
        maxLength = max;
    }

    @Override
    public void print(int priority, String tag, String message) {
        if (isNew) {
            while (message.length() > maxLength) {
                int index = message.lastIndexOf(NEW_LINE, maxLength);
                if (index < 0) index = maxLength - 1;
                Log.println(priority, tag, message.substring(0, index));
                if (NEW_LINE.equals(message.substring(index, index + 1))) {
                    message = message.substring(index + 1);
                } else {
                    message = message.substring(index);
                }
            }
            Log.println(priority, tag, message);
        } else {
            String[] result = message.split(NEW_LINE);
            for (String msg : result) {
                Log.println(priority, tag, msg);
            }
        }
    }
}
