package cn.keayuan.util.log.disk;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.Logger;
import cn.keayuan.util.log.PrintStrategy;
import cn.keayuan.util.log.Printer;

public class DiskPrinter extends Printer {

    private static final String[] names = {"UNKNOWN", "UNKNOWN", "VERBOSE", "DEBUG", "INFO", "WARN", "ERROR", "ASSERT"};

    private static final String SEPARATOR = " ";
    private final Date date = new Date();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);

    public DiskPrinter(String path) {
        this(new DiskLogStrategy(path));
    }

    public DiskPrinter(PrintStrategy strategy) {
        super(strategy);
    }

    @Override
    public String formatTag(int priority, String tag) {
        if (tag == null) {
            tag = "";
        }
        date.setTime(System.currentTimeMillis());
        return dateFormat.format(date) + SEPARATOR + Thread.currentThread()
            .getId() + SEPARATOR + logLevel(priority) + SEPARATOR + tag;
    }

    @Override
    public String format(String msg) {
        return msg + NEW_LINE;
    }

    private static String logLevel(int value) {
        if (value < 0 || value > Logger.ASSERT) return names[0];
        return names[value];
    }

    @Override
    public void print(int priority, String tag, String message) {
    }
}
