package cn.keayuan.util.log;

/**
 * @author ex-keayuan001
 */
public abstract class Printer {

    protected static final String NEW_LINE;

    static {
        String line = System.getProperty("line.separator");
        NEW_LINE = line == null ? "\n" : line;
    }

    protected PrintStrategy printStrategy;

    public Printer() {
    }

    public Printer(PrintStrategy strategy) {
        this.printStrategy = strategy;
    }

    /**
     * Each log will use this pipeline
     *
     * @param priority is the log level e.g. DEBUG, WARNING
     * @param tag      is the given tag for the log message.
     * @param message  is the given message for the log message.
     */
    final synchronized void log(int priority, String tag, String message) {
        if (printStrategy == null) {
            if (isLoggable(priority, tag)) {
                tag = formatTag(priority, tag);
                message = format(message);
                print(priority, tag, message);
            }
        } else {
            Object temp = printStrategy.isLoggable(priority, tag);
            if (temp == null ? isLoggable(priority, tag) : (Boolean) temp) {

                temp = printStrategy.formatTag(priority, tag);
                if (temp == null) temp = formatTag(priority, tag);
                tag = String.valueOf(temp);

                temp = printStrategy.format(message);
                if (temp == null) temp = format(message);
                message = String.valueOf(temp);

                if (!printStrategy.print(priority, tag, message)) print(priority, tag, message);
            }
        }
    }

    protected boolean isLoggable(int priority, String tag) {
        return true;
    }

    protected String formatTag(int priority, String tag) {
        return tag;
    }

    protected String format(String msg) {
        return msg;
    }

    protected abstract void print(int priority, String tag, String message);

    @Override
    public int hashCode() {
        return getClass().getName().hashCode();
    }
}
