package cn.keayuan.util.log;

/**
 * Determines destination target for the logs such as Disk, Logcat etc.
 */
public interface PrintStrategy {

    String NEW_LINE = System.getProperty("line.separator");

    default Boolean isLoggable(int priority, String tag) {
        return null;
    }

    default String formatTag(int priority, String tag) {
        return null;
    }

    default String format(String msg) {
        return null;
    }

    /**
     * print log
     *
     * @param priority priority
     * @param tag      tag
     * @param message  message
     * @return 是否打印，返回true表示已经打印
     */
    default boolean print(int priority, String tag, String message) {
        return false;
    }
}
