package cn.keayuan.util.log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by sskbskdrin on 2022/7/5.
 *
 * @author sskbskdrin
 */
public class JsonFormatter implements Format {
    @Override
    public boolean format(StringBuilder builder, Object obj) {
        try {
            if (obj instanceof String) {
                String json = ((String) obj).trim();
                if (json.startsWith("{")) {
                    JSONObject object = new JSONObject(json);
                    builder.append("\n").append(object.toString(2));
                }
                if (json.startsWith("[")) {
                    JSONArray array = new JSONArray(json);
                    builder.append("\n").append(array.toString(2));
                }
            } else if (obj instanceof JSONObject) {
                builder.append(((JSONObject) obj).toString(2));
            } else if (obj instanceof JSONArray) {
                builder.append(((JSONArray) obj).toString(2));
            } else {
                return false;
            }
            return true;
        } catch (JSONException ignored) {
        }
        return false;
    }
}
