package cn.keayuan.util.log;

/**
 * default format %s replace obj.toString()
 * Created by keayuan on 2021/9/2.
 *
 * @author keayuan
 */
class DefaultFormat implements LogFormat {

    private final Format objFormat;

    DefaultFormat(Format format) {
        objFormat = format;
    }

    @Override
    public void format(StringBuilder builder, String message, Object... obj) {
        if (message == null || message.length() == 0) return;
        if (obj != null && obj.length > 0) {
            int index = 0;
            while (message != null) {
                int i = message.indexOf("%%");
                String s = message.substring(0, i >= 0 ? i : message.length());
                while (s != null) {
                    int pos = s.indexOf("%s");
                    if (pos >= 0) {
                        builder.append(s.substring(0, pos));
                        if (index < obj.length) {
                            objFormat.format(builder, obj[index++]);
                        } else {
                            builder.append("%s");
                        }
                        s = s.substring(pos + 2);
                    } else {
                        builder.append(s);
                        s = null;
                    }
                }
                if (i >= 0) {
                    builder.append("%");
                    message = message.substring(i + 2);
                } else {
                    message = null;
                }
            }
            while (index < obj.length) {
                objFormat.format(builder, obj[index++]);
            }
        } else {
            builder.append(message);
        }
    }
}
