/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.printer;

import cn.keayuan.util.log.Printer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class DiskPrinter
extends Printer
implements Runnable {
    private static final String[] names = new String[]{"UNKNOWN", "UNKNOWN", "VERBOSE", "DEBUG", "INFO", "WARN", "ERROR", "ASSERT"};
    private static final String SEPARATOR = " ";
    private final Date date = new Date();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
    private int mMaxFileSize = 0x100000;
    private final String fileName;
    private final String mPath;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();
    private Executor executor;
    private RandomAccessFile out;
    private volatile boolean isRunning;

    public DiskPrinter(String filePath, String fileName) {
        this(filePath, fileName, 0x800000);
    }

    public DiskPrinter(String filePath, String fileName, int maxFileSize) {
        this.mPath = filePath;
        if (maxFileSize > this.mMaxFileSize) {
            this.mMaxFileSize = maxFileSize;
        }
        this.fileName = fileName == null ? "log" : fileName;
    }

    @Override
    public String formatTag(int priority, String tag) {
        if (tag == null) {
            tag = "";
        }
        this.date.setTime(System.currentTimeMillis());
        return this.dateFormat.format(this.date) + SEPARATOR + Thread.currentThread().getId() + SEPARATOR + DiskPrinter.logLevel(priority) + SEPARATOR + tag;
    }

    @Override
    public String format(String msg) {
        return msg + NEW_LINE;
    }

    private static String logLevel(int value) {
        if (value < 0 || value > 7) {
            return names[0];
        }
        return names[value];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(int priority, String tag, String message) {
        this.queue.offer(tag + ":" + message);
        if (this.executor == null) {
            DiskPrinter diskPrinter = this;
            synchronized (diskPrinter) {
                this.executor = Executors.newSingleThreadExecutor();
            }
            if (!this.isRunning) {
                this.executor.execute(this);
            }
        }
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                String item = this.queue.take();
                if (this.out == null) {
                    this.out = DiskPrinter.getFileOutputStream(this.mPath, this.fileName, this.mMaxFileSize);
                }
                this.out.write(item.getBytes());
                if (this.out.length() <= (long)this.mMaxFileSize) continue;
                this.out.close();
                this.out = null;
            }
            catch (FileNotFoundException | InterruptedException e) {
                e.printStackTrace();
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.isRunning = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static RandomAccessFile getFileOutputStream(String folderName, String fileName, int maxSize) throws FileNotFoundException {
        long length;
        File newFile;
        File folder = new File(folderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((newFile = new File(folder, fileName + ".log")).exists() && (length = newFile.length()) > (long)maxSize) {
            File temp;
            int newFileCount = 0;
            while ((temp = new File(folder, String.format("%s_%s.log", fileName, newFileCount++))).exists()) {
            }
            newFile.renameTo(temp);
            newFile = new File(folder, fileName + ".log");
        }
        return new RandomAccessFile(newFile, "rw");
    }
}

