/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import cn.keayuan.util.log.DefaultLog;
import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.ILogProvider;
import cn.keayuan.util.log.LogImpl;
import cn.keayuan.util.log.PLog;
import cn.keayuan.util.log.format.DefaultFormat;
import cn.keayuan.util.log.format.JsonFormatter;
import cn.keayuan.util.log.format.LogFormat;
import cn.keayuan.util.log.format.ObjectFormatter;
import cn.keayuan.util.log.format.XmlFormatter;
import cn.keayuan.util.log.printer.ConsolePrinter;
import cn.keayuan.util.log.printer.LogcatPrinter;
import java.util.HashSet;
import java.util.Set;

public final class LoggerFactory
implements ILogProvider<ILog> {
    final Set<PLog> logPrinters = new HashSet<PLog>();
    String TAG_PREFIX = "global";
    LogFormat formatter;
    int priority = 2;
    private static final LoggerFactory defaultFactory = new LoggerFactory("default");

    private LoggerFactory(String tag) {
        this.tag(tag);
        ObjectFormatter objFormat = new ObjectFormatter(LoggerFactory.testClass("org.json.JSONObject") ? new JsonFormatter() : null, LoggerFactory.testClass("javax.xml.transform.Source") ? new XmlFormatter() : null);
        this.formatter = new DefaultFormat(objFormat);
        this.logPrinters.add(DefaultLog.isAndroid ? new LogcatPrinter() : new ConsolePrinter(true));
    }

    public LoggerFactory tag(String tagPrefix) {
        this.TAG_PREFIX = tagPrefix;
        return this;
    }

    public LoggerFactory addPinter(PLog ... printers) {
        for (PLog printer : printers) {
            if (printer == null) continue;
            if (!DefaultLog.isAndroid && printer instanceof LogcatPrinter) {
                throw new IllegalArgumentException("not support LogcatPrinter");
            }
            this.logPrinters.add(printer);
        }
        return this;
    }

    public LoggerFactory clearPrinters() {
        this.logPrinters.clear();
        return this;
    }

    public LoggerFactory setLogPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public LoggerFactory setFormatter(LogFormat formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("formatter Can not be null");
        }
        this.formatter = formatter;
        return this;
    }

    public ILog getLogger(String tag) {
        return new LogImpl(tag, this);
    }

    public static LoggerFactory createFactory(String tagPrefix) {
        return new LoggerFactory(tagPrefix);
    }

    public static LoggerFactory defaultFactory() {
        return defaultFactory;
    }

    private static boolean testClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

