/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.LoggerFactory;
import cn.keayuan.util.log.PLog;

class LogImpl
implements ILog {
    private static final ThreadLocal<StringBuilder> thBuilder = new ThreadLocal();
    private final String tag;
    private final LoggerFactory factory;

    LogImpl(String tag, LoggerFactory factory) {
        this.tag = tag;
        this.factory = factory;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isLoggable(int priority) {
        return this.factory.priority <= priority;
    }

    public synchronized void log(int priority, String tag, String msg, Object ... obj) {
        String finalTag;
        if (!this.isLoggable(priority)) {
            return;
        }
        StringBuilder builder = thBuilder.get();
        if (builder == null) {
            builder = new StringBuilder();
            thBuilder.set(builder);
        }
        builder.setLength(0);
        this.factory.formatter.format(builder, msg, obj);
        String finalContent = builder.toString();
        String string = finalTag = tag == null || tag.isEmpty() ? this.getTag() : tag;
        if (this.factory.TAG_PREFIX != null && !this.factory.TAG_PREFIX.isEmpty()) {
            finalTag = this.factory.TAG_PREFIX + "_" + finalTag;
        }
        if (builder.length() > 32768) {
            thBuilder.remove();
        }
        for (PLog printer : this.factory.logPrinters) {
            printer.log(priority, finalTag, finalContent, new Object[0]);
        }
    }
}

