package cn.keayuan.util.log.format;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/**
 * Created by sskbskdrin on 2022/5/7.
 *
 * @author sskbskdrin
 */
public class XmlFormatter implements Format {

    @Override
    public boolean format(StringBuilder builder, Object obj) {
        try {
            if (obj instanceof String) {
                String xml = ((String) obj).trim();
                if (xml.startsWith("<") && xml.endsWith(">")) {
                    Source xmlInput = new StreamSource(new StringReader(xml));
                    StreamResult xmlOutput = new StreamResult(new StringWriter());
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty(OutputKeys.METHOD, "html");
                    transformer.setOutputProperty(OutputKeys.INDENT, "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(2));
                    transformer.transform(xmlInput, xmlOutput);
                    builder.append("\n").append(xmlOutput.getWriter().toString()).append("\n");
                    return true;
                }
            }
        } catch (TransformerException ignored) {
        }
        return false;
    }
}
