/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.printer;

import android.os.Process;
import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.printer.LogcatPrinter;

public class LogcatPrettyPrinter
extends LogcatPrinter {
    private static final int CHUNK_SIZE = 4000;
    private static final int MIN_STACK_OFFSET = 8;
    private static final char HORIZONTAL_LINE = '\u2502';
    private static final String MIDDLE_BORDER = "================================";
    private static final String SINGLE_DIVIDER = "\u2502------------------------------------------------------------------------------------------------";
    private static final String THREAD_INFO = "\u250c================================    Thread:%s    ID:%s    ================================";
    private static final String BOTTOM_BORDER = "\u2514================================================================================================";
    private static final String METHOD_INFO = "%s%s.%s (%s:%s)";
    private int methodCount;
    private int methodOffset;
    private boolean logMethod = true;
    private final StringBuilder mBuilder = new StringBuilder(4000);

    public LogcatPrettyPrinter() {
        this(8, 0);
    }

    public LogcatPrettyPrinter(int count, int offset) {
        this.methodCount = count;
        if (this.methodCount < 0) {
            this.methodCount = 0;
        }
        this.methodOffset = offset;
        if (this.methodOffset < 0) {
            this.methodOffset = 0;
        }
    }

    private void logHeaderContent(StringBuilder builder) {
        this.mBuilder.append(' ');
        this.mBuilder.append(NEW_LINE);
        Thread thread = Thread.currentThread();
        builder.append(String.format(THREAD_INFO, thread.getName(), Process.myTid()));
    }

    private void logMethod(StringBuilder builder) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int stackOffset = this.getStackOffset(trace) + this.methodOffset;
        StringBuilder level = new StringBuilder(" ");
        for (int i = stackOffset + this.methodCount; i >= stackOffset; --i) {
            if (i >= trace.length || i < 0) continue;
            builder.append(NEW_LINE);
            builder.append('\u2502');
            builder.append(String.format(METHOD_INFO, level.toString(), trace[i].getClassName(), trace[i].getMethodName(), trace[i].getFileName(), trace[i].getLineNumber()));
            level.append("  ");
        }
        builder.append(NEW_LINE);
        builder.append(SINGLE_DIVIDER);
    }

    private void logBottomBorder(StringBuilder builder) {
        builder.append(NEW_LINE);
        builder.append(BOTTOM_BORDER);
    }

    private void logContent(StringBuilder builder, String msg) {
        builder.append(NEW_LINE);
        builder.append('\u2502');
        builder.append(msg);
    }

    private int getStackOffset(StackTraceElement[] trace) {
        for (int i = 8; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (name.equals(ILog.class.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String formatTag(int priority, String tag) {
        this.logMethod = priority >= 5;
        return tag;
    }

    @Override
    public String format(String msg) {
        String[] temp;
        this.mBuilder.setLength(0);
        this.logHeaderContent(this.mBuilder);
        if (this.logMethod) {
            this.logMethod(this.mBuilder);
        }
        for (String content : temp = msg.split(NEW_LINE)) {
            if (content.length() <= 4000) {
                this.logContent(this.mBuilder, content);
                continue;
            }
            for (int i = 0; i < content.length(); i += 4000) {
                int count = Math.min(content.length() - i, 4000);
                this.logContent(this.mBuilder, content.substring(i, i + count));
            }
        }
        this.logBottomBorder(this.mBuilder);
        return this.mBuilder.toString();
    }
}

