/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.LogImpl;
import cn.keayuan.util.log.PLog;
import cn.keayuan.util.log.Printer;
import cn.keayuan.util.log.format.DefaultFormat;
import cn.keayuan.util.log.format.Format;
import cn.keayuan.util.log.format.JsonFormatter;
import cn.keayuan.util.log.format.LogFormat;
import cn.keayuan.util.log.format.ObjectFormatter;
import cn.keayuan.util.log.format.XmlFormatter;
import cn.keayuan.util.log.printer.ConsolePrinter;
import cn.keayuan.util.log.printer.LogcatPrinter;
import java.util.HashSet;
import java.util.Set;

public final class LoggerFactory {
    private static final String TAG = "LoggerFactory";
    private static boolean logcat;
    private Printer defaultPrint;
    private Format objFormat;
    final Set<PLog> logPrinters = new HashSet<PLog>();
    String TAG_PREFIX = "global";
    LogFormat formatter;
    int priority = 2;
    private static final LoggerFactory defaultFactory;

    private LoggerFactory() {
        this.objFormat = new ObjectFormatter(LoggerFactory.testClass("org.json.JSONObject") ? new JsonFormatter() : null, LoggerFactory.testClass("javax.xml.transform.Source") ? new XmlFormatter() : null);
        this.formatter = new DefaultFormat(this.objFormat);
        try {
            Class.forName("android.util.Log");
            Class<?> cls = Class.forName("android.os.Build$VERSION");
            logcat = cls.getField("SDK_INT").getInt(cls) > 0;
        }
        catch (ClassNotFoundException ignored) {
            System.out.println("LoggerFactory:\u73af\u5883\u4e0d\u652f\u6301 logcat, \u6ca1\u6709\u627e\u5230android.util.Log");
        }
        catch (NoSuchFieldException ignored) {
            System.out.println("LoggerFactory:\u73af\u5883\u4e0d\u652f\u6301 logcat, \u6ca1\u6709\u627e\u5230android.os.Build$VERSION.SDK_INI");
        }
        catch (IllegalAccessException ignored) {
            System.out.println("LoggerFactory:\u73af\u5883\u4e0d\u652f\u6301 logcat, \u6ca1\u6709\u627e\u5230android.os.Build$VERSION.SDK_INI");
        }
        this.defaultPrint = logcat ? new LogcatPrinter() : new ConsolePrinter(true);
        this.logPrinters.add(this.defaultPrint);
    }

    public void tag(String tagPrefix) {
        this.TAG_PREFIX = tagPrefix;
    }

    public void addPinter(PLog ... printers) {
        for (PLog printer : printers) {
            if (printer == null) continue;
            if (!logcat && printer instanceof LogcatPrinter) {
                throw new IllegalArgumentException("\u73af\u5883\u4e0d\u652f\u6301 cn.sskbskdrin.log.logcat, \u6ca1\u6709\u627e\u5230android.util.Log");
            }
            if (this.defaultPrint != null) {
                this.logPrinters.remove(this.defaultPrint);
                this.defaultPrint = null;
            }
            this.logPrinters.add(printer);
        }
    }

    public void clearPrinters() {
        this.logPrinters.clear();
    }

    public void setLogPriority(int priority) {
        this.priority = priority;
    }

    public void setFormatter(LogFormat formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("formatter Can not be null");
        }
        this.formatter = formatter;
    }

    public void setObjectFormat(Format formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("formatter Can not be null");
        }
        this.objFormat = formatter;
    }

    public ILog getLogger(Class<?> cls) {
        return new LogImpl(cls.getSimpleName(), this);
    }

    public ILog getLogger(String tag) {
        return new LogImpl(tag, this);
    }

    public static LoggerFactory createLoggerFactory() {
        return new LoggerFactory();
    }

    public static LoggerFactory defaultFactory() {
        return defaultFactory;
    }

    private static boolean testClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static {
        defaultFactory = new LoggerFactory();
    }
}

