/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.LoggerFactory;
import cn.keayuan.util.log.PLog;
import java.util.concurrent.ConcurrentHashMap;

class LogImpl
implements ILog {
    private static final ConcurrentHashMap<Long, StringBuilder> map = new ConcurrentHashMap();
    private final String tag;
    private final LoggerFactory factory;

    LogImpl(String tag, LoggerFactory factory) {
        this.tag = tag;
        this.factory = factory;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isLoggable(int priority) {
        return this.factory.priority <= priority;
    }

    public synchronized void log(int priority, String tag, String msg, Object ... obj) {
        String finalTag;
        if (!this.isLoggable(priority)) {
            return;
        }
        StringBuilder builder = map.get(Thread.currentThread().getId());
        if (builder == null) {
            builder = new StringBuilder();
            map.put(Thread.currentThread().getId(), builder);
        }
        builder.setLength(0);
        this.factory.formatter.format(builder, msg, obj);
        String finalContent = builder.toString();
        String string = finalTag = tag == null || tag.isEmpty() ? this.getTag() : tag;
        if (this.factory.TAG_PREFIX != null && !this.factory.TAG_PREFIX.isEmpty()) {
            finalTag = this.factory.TAG_PREFIX + "_" + finalTag;
        }
        if (builder.length() > 32768) {
            map.put(Thread.currentThread().getId(), new StringBuilder());
        }
        for (PLog printer : this.factory.logPrinters) {
            printer.log(priority, finalTag, finalContent, new Object[0]);
        }
    }
}

