package cn.keayuan.util.log.printer;

import android.util.Log;

import cn.keayuan.util.log.Printer;

public class LogcatPrinter extends Printer {

    private int maxLength = 3000;

    public LogcatPrinter() {}

    public LogcatPrinter(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void print(int priority, String tag, String message) {
        while (message.length() > maxLength) {
            int index = message.lastIndexOf(NEW_LINE, maxLength);
            if (index < 0) index = maxLength - 1;
            Log.println(priority, tag, message.substring(0, index));
            if (NEW_LINE.equals(message.substring(index, index + 1))) {
                message = message.substring(index + 1);
            } else {
                message = message.substring(index);
            }
        }
        Log.println(priority, tag, message);
    }
}
