package cn.keayuan.util.log.printer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import cn.keayuan.util.log.Logger;
import cn.keayuan.util.log.Printer;

public class ConsolePrinter extends Printer {

    private final Date date = new Date();
    private final SimpleDateFormat dateFormat;
    private final boolean pretty;

    public ConsolePrinter(boolean colorEnable) {
        dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.getDefault());
        pretty = colorEnable;
    }

    @Override
    protected String formatTag(int priority, String tag) {
        if (tag == null) {
            tag = "";
        }
        String type = "";
        String start = "";
        switch (priority) {
            case Logger.VERBOSE:
                type = " V/";
                start = "\u001b[30;37m";
                break;
            case Logger.DEBUG:
                type = " D/";
                start = "\u001b[30;34m";
                break;
            case Logger.INFO:
                type = " I/";
                start = "\u001b[30;32m";
                break;
            case Logger.WARN:
                type = " W/";
                start = "\u001b[30;33m";
                break;
            case Logger.ERROR:
                type = " E/";
                start = "\u001b[30;31m";
                break;
            default:
        }
        if (!pretty) {
            start = "";
        }
        date.setTime(System.currentTimeMillis());
        return start + dateFormat.format(date) + " " + Thread.currentThread().getId() + type + tag + ": ";
    }

    @Override
    protected String format(String msg) {
        return pretty ? msg + "\u001b[0m" : msg;
    }

    @Override
    public void print(int priority, String tag, String message) {
        String[] result = message.split(NEW_LINE);
        for (String msg : result) {
            System.out.println(tag + msg);
        }
    }
}
