package cn.keayuan.util.log.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.UnknownHostException;
import java.util.Arrays;

/**
 * Created by sskbskdrin on 2022/7/5.
 *
 * @author sskbskdrin
 */
public class ObjectFormatter implements Format {
    private static final String NULL = "null";
    private Format jsonFormat;
    private Format xmlFormat;

    public ObjectFormatter(Format jsonFormat, Format xmlFormat) {
        this.jsonFormat = jsonFormat;
        this.xmlFormat = xmlFormat;
    }

    public void setJsonFormat(Format jsonFormat) {
        this.jsonFormat = jsonFormat;
    }

    public void setXmlFormat(Format xmlFormat) {
        this.xmlFormat = xmlFormat;
    }

    @Override
    public boolean format(StringBuilder builder, Object obj) {
        objToString(builder, obj);
        return true;
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return NULL;
        }
        Throwable t = tr;
        while (t != null) {
            if (t instanceof UnknownHostException) {
                return t.toString();
            }
            t = t.getCause();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private void objToString(StringBuilder builder, Object obj) {
        if (builder == null) {
            return;
        }
        if (jsonFormat != null && jsonFormat.format(builder, obj)) {
            return;
        }
        if (xmlFormat != null && xmlFormat.format(builder, obj)) {
            return;
        }
        if (obj == null) {
            builder.append(NULL);
        } else if (obj instanceof Throwable) {
            builder.append('\n').append(getStackTraceString((Throwable) obj));
        } else if (obj.getClass().isArray()) {
            builder.append('[');
            if (Array.getLength(obj) > 0) {
                arrayString(builder, obj);
                builder.setLength(builder.length() - 1);
            }
            builder.append(']');
        } else if (obj instanceof String) {
            builder.append((String) obj);
        } else {
            builder.append(obj);
        }
    }

    private void arrayString(StringBuilder builder, Object obj) {
        if (obj instanceof boolean[]) {
            boolString(builder, (boolean[]) obj);
            Arrays.toString((boolean[]) obj);
        } else if (obj instanceof byte[]) {
            byteString(builder, (byte[]) obj);
        } else if (obj instanceof char[]) {
            charString(builder, (char[]) obj);
        } else if (obj instanceof short[]) {
            shortString(builder, (short[]) obj);
        } else if (obj instanceof int[]) {
            intString(builder, (int[]) obj);
        } else if (obj instanceof float[]) {
            floatString(builder, (float[]) obj);
        } else if (obj instanceof long[]) {
            longString(builder, (long[]) obj);
        } else if (obj instanceof double[]) {
            doubleString(builder, (double[]) obj);
        } else {
            objectString(builder, (Object[]) obj);
        }
    }

    private static void boolString(StringBuilder builder, boolean[] value) {
        for (boolean b : value) {
            builder.append(b).append(',');
        }
    }

    private static void byteString(StringBuilder builder, byte[] value) {
        for (byte b : value) {
            builder.append(Integer.toHexString(b & 0xff)).append(',');
        }
    }

    private static void charString(StringBuilder builder, char[] value) {
        for (char b : value) {
            builder.append(b).append(',');
        }
    }

    private static void shortString(StringBuilder builder, short[] value) {
        for (short b : value) {
            builder.append(b).append(',');
        }
    }

    private static void intString(StringBuilder builder, int[] value) {
        for (int b : value) {
            builder.append(b).append(',');
        }
    }

    private static void floatString(StringBuilder builder, float[] value) {
        for (float b : value) {
            builder.append(b).append(',');
        }
    }

    private static void longString(StringBuilder builder, long[] value) {
        for (long b : value) {
            builder.append(b).append(',');
        }
    }

    private static void doubleString(StringBuilder builder, double[] value) {
        for (double b : value) {
            builder.append(b).append(',');
        }
    }

    private void objectString(StringBuilder builder, Object[] value) {
        for (Object b : value) {
            objToString(builder, b);
            builder.append(',');
        }
    }
}
