package cn.keayuan.util.log;

/**
 * @author ex-keayuan001
 */
public abstract class Printer implements PLog {

    protected static final String NEW_LINE;

    static {
        String line = System.getProperty("line.separator");
        NEW_LINE = line == null ? "\n" : line;
    }

    public Printer() {
    }

    @Override
    public final void log(int priority, String tag, String message, Object... obj) {
        if (isLoggable(priority, tag)) {
            tag = formatTag(priority, tag);
            message = format(message);
            print(priority, tag, message);
        }
    }

    protected boolean isLoggable(int priority, String tag) {
        return true;
    }

    protected String formatTag(int priority, String tag) {
        return tag;
    }

    protected String format(String msg) {
        return msg;
    }

    protected abstract void print(int priority, String tag, String message);

    @Override
    public int hashCode() {
        return getClass().getName().hashCode();
    }
}
