package cn.keayuan.util.log;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by keayuan on 2021.12.28.
 *
 * @author keayuan
 */
class LogImpl implements ILog {

    private static final ConcurrentHashMap<Long, StringBuilder> map = new ConcurrentHashMap<>();

    private final String tag;
    private final LoggerFactory factory;

    LogImpl(String tag, LoggerFactory factory) {
        this.tag = tag;
        this.factory = factory;
    }

    @Override
    public String getTag() {
        return tag;
    }

    @Override
    public boolean isLoggable(int priority) {
        return factory.priority <= priority;
    }

    @Override
    public synchronized void log(int priority, String tag, String msg, Object... obj) {
        if (!isLoggable(priority)) return;
        StringBuilder builder = map.get(Thread.currentThread().getId());
        if (builder == null) {
            builder = new StringBuilder();
            map.put(Thread.currentThread().getId(), builder);
        }
        builder.setLength(0);
        factory.formatter.format(builder, msg, obj);
        String finalContent = builder.toString();
        String finalTag = tag == null || tag.isEmpty() ? getTag() : tag;
        if (factory.TAG_PREFIX != null && !factory.TAG_PREFIX.isEmpty()) {
            finalTag = factory.TAG_PREFIX + "_" + finalTag;
        }
        if (builder.length() > 32 * 1024) {
            map.put(Thread.currentThread().getId(), new StringBuilder());
        }
        for (PLog printer : factory.logPrinters) {
            printer.log(priority, finalTag, finalContent);
        }
    }
}
