/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewbinding.ViewBinding;
import cn.keayuan.ui.IViewBind;
import cn.keayuan.ui.adapter.AdapterInternal;
import cn.keayuan.ui.adapter.IHolder;
import cn.keayuan.ui.adapter.IViewAdapter;
import cn.keayuan.ui.adapter.VBHolder;
import cn.keayuan.util.function.BiFunction;

public class IAdapter<T, VH extends IHolder<T>>
extends RecyclerView.Adapter<VHInternal<T, VH>>
implements IViewAdapter<T, VH> {
    private final AdapterInternal<T, VH> internal;

    public IAdapter() {
        this(null);
    }

    public IAdapter(int layoutId) {
        this(IAdapter.builder(layoutId));
    }

    protected IAdapter(IViewAdapter.Builder<T, VH, ? extends IViewAdapter<T, VH>> builder) {
        this.internal = new AdapterInternal(builder);
    }

    @NonNull
    public final VHInternal<T, VH> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new VHInternal(this.onCreateHolder(parent, viewType));
    }

    public final void onBindViewHolder(@NonNull VHInternal<T, VH> holder, int position) {
        this.internal.bindHolder((IViewAdapter)this, holder.holder, position);
        this.onBindHolder((IHolder)holder.holder);
    }

    public final int getItemCount() {
        return this.getTotalCount();
    }

    public int getItemViewType(int position) {
        if (this.internal.viewTypeProvider != null) {
            return (Integer)this.internal.viewTypeProvider.apply((Object)position);
        }
        return super.getItemViewType(position);
    }

    public final AdapterInternal<T, VH> getInternal() {
        return this.internal;
    }

    public static <B, VH extends IHolder<B>> Builder<B, VH> builder(int layoutId) {
        return new Builder(layoutId);
    }

    public static <B, VH extends IHolder<B>> Builder<B, VH> builder(BiFunction<ViewGroup, Integer, VH> vhProvider) {
        return new Builder(vhProvider);
    }

    public static <B, V extends ViewBinding> VBBuilder<B, V> builder(Class<B> bClass, Class<V> clazz) {
        return new VBBuilder<B, V>(bClass, clazz);
    }

    public static class VBBuilder<B, V extends ViewBinding>
    extends Builder<B, VBHolder<B, V>> {
        public VBBuilder(Class<B> bCls, Class<V> clazz) {
            this(clazz);
        }

        public VBBuilder(Class<V> clazz) {
            super((group, integer) -> {
                ViewBinding vb = (ViewBinding)IViewBind.getViewBinding(clazz, group, LayoutInflater.from((Context)group.getContext()), false);
                if (vb == null) {
                    throw new IllegalArgumentException("vb method inflate() not find");
                }
                return new VBHolder(vb);
            });
        }

        public VBBuilder(BiFunction<ViewGroup, Integer, VBHolder<B, V>> supplier) {
            super(supplier);
        }
    }

    public static class Builder<B, VH extends IHolder<B>>
    extends IViewAdapter.Builder<B, VH, IAdapter<B, VH>> {
        public Builder(int layoutId) {
            super(layoutId);
        }

        public Builder(BiFunction<ViewGroup, Integer, VH> vhProvider) {
            super(vhProvider);
        }

        public IAdapter<B, VH> build() {
            return new IAdapter(this);
        }
    }

    protected static class VHInternal<B, VH extends IHolder<B>>
    extends RecyclerView.ViewHolder {
        VH holder;

        public VHInternal(@NonNull VH holder) {
            super(holder.rootView());
            this.holder = holder;
        }
    }
}

