/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.ui;

import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.viewbinding.ViewBinding;
import cn.keayuan.ui.UtilX;
import cn.keayuan.util.log.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public interface IViewBind<V extends ViewBinding> {
    default public int getViewBindIndex() {
        return 0;
    }

    default public V getViewBinding() {
        int index = this.getViewBindIndex();
        if (index < 0) {
            throw new IllegalStateException("getViewBindIndex " + index);
        }
        Class clazz = UtilX.getGenericTypeClass(this.getClass(), index, ViewBinding.class);
        if (clazz == null) {
            return null;
        }
        return (V)((ViewBinding)IViewBind.getViewBinding(clazz, this.getViewParent(), this.getLayoutInflater(), true));
    }

    public static <V> V getViewBinding(Class<V> vbClass, ViewGroup parent, LayoutInflater inflater, boolean attachToParent) {
        try {
            if (parent == null) {
                Method method = vbClass.getMethod("inflate", LayoutInflater.class);
                return (V)method.invoke(null, inflater);
            }
            Method method = vbClass.getMethod("inflate", LayoutInflater.class, ViewGroup.class, Boolean.TYPE);
            return (V)method.invoke(null, inflater, parent, attachToParent);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Logger.e((String)"IViewBind", (String)e.getMessage(), (Object[])new Object[]{e});
            return null;
        }
    }

    public LayoutInflater getLayoutInflater();

    default public ViewGroup getViewParent() {
        return null;
    }
}

