/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.ui;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public interface IRecyclerView {
    public RecyclerView getRecyclerView();

    default public void setLayoutManager(Layout layout) {
        this.setLayoutManager(layout, true);
    }

    default public void setLayoutManager(Layout layout, boolean isVertical) {
        this.setLayoutManager(layout, isVertical, 0);
    }

    default public void setLayoutManager(Layout layout, boolean isVertical, int count) {
        this.setLayoutManager(layout, isVertical, count, false);
    }

    default public void setLayoutManager(Layout layout, boolean isVertical, int count, boolean reverse) {
        RecyclerView view = this.getRecyclerView();
        int or = isVertical ? 1 : 0;
        switch (layout) {
            case STAGGERED: {
                view.setLayoutManager((RecyclerView.LayoutManager)new StaggeredGridLayoutManager(count, or));
                break;
            }
            case GRID: {
                view.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(view.getContext(), count, or, reverse));
                break;
            }
            case LINEAR: {
                view.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext(), or, reverse));
                break;
            }
        }
    }

    default public void setAdapter(RecyclerView.Adapter adapter) {
        this.getRecyclerView().setAdapter(adapter);
    }

    default public <T extends RecyclerView.Adapter> T getAdapter() {
        return (T)this.getRecyclerView().getAdapter();
    }

    default public void addItemDecoration(RecyclerView.ItemDecoration decoration) {
        this.getRecyclerView().addItemDecoration(decoration);
    }

    public static enum Layout {
        LINEAR,
        GRID,
        STAGGERED;

    }
}

