/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import cn.keayuan.ui.IA;
import cn.keayuan.ui.IPageX;
import cn.keayuan.util.log.Logger;

public abstract class IFragment
extends Fragment
implements IA,
IPageX {
    protected final String TAG = this.getClass().getSimpleName();
    protected View mRootView;
    private Activity mActivity;
    private boolean firstCreateView = true;

    protected abstract int getLayoutId();

    protected void onInitData(Bundle arguments) {
    }

    protected abstract void onInitView(View var1, Bundle var2);

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof Activity) {
            this.mActivity = (Activity)context;
        }
        Logger.v((String)this.TAG, (String)"onAttach", (Object[])new Object[0]);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.v((String)this.TAG, (String)"onCreate", (Object[])new Object[0]);
        Bundle bundle = this.getArguments();
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.onInitData(bundle);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ViewGroup parent;
        if (this.mRootView == null) {
            Logger.v((String)this.TAG, (String)"onCreateView new", (Object[])new Object[0]);
            int layoutId = this.getLayoutId();
            if (layoutId > 0) {
                this.mRootView = inflater.inflate(layoutId, null);
            }
        }
        if (this.mRootView == null) {
            this.mRootView = this.generateRootView(inflater, container, savedInstanceState);
        }
        if (this.mRootView != null && (parent = (ViewGroup)this.mRootView.getParent()) != null) {
            Logger.v((String)this.TAG, (String)"onCreateView old", (Object[])new Object[0]);
            parent.removeView(this.mRootView);
        }
        if (this.firstCreateView) {
            this.firstCreateView = false;
            this.onInitView(this.mRootView, savedInstanceState);
        }
        return this.mRootView;
    }

    protected View generateRootView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return null;
    }

    protected boolean isDestroyView() {
        return false;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.isDestroyView()) {
            this.mRootView = null;
            this.firstCreateView = true;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        Logger.v((String)this.TAG, (String)"onDestroy", (Object[])new Object[0]);
        this.mActivity = null;
    }

    public void onDetach() {
        super.onDetach();
        this.mActivity = null;
        Logger.v((String)this.TAG, (String)"onDetach", (Object[])new Object[0]);
    }

    public boolean isFinish() {
        return this.mActivity == null || this.mActivity.isFinishing();
    }

    public <T extends View> T getView(int id) {
        return (T)this.mRootView.findViewById(id);
    }

    protected final <T extends View> T getRootView() {
        return (T)this.mRootView;
    }

    @Override
    public FragmentManager getSupportFragmentManager() {
        return this.getChildFragmentManager();
    }
}

