/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.ui.vm;

import androidx.lifecycle.LifecycleOwner;
import cn.keayuan.ui.vm.BaseModel;
import cn.keayuan.ui.vm.BiObservable;
import cn.keayuan.ui.vm.BiObserver;
import cn.keayuan.ui.vm.IModel;
import cn.keayuan.ui.vm.LifeOwner;
import cn.keayuan.ui.vm.Observer;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimpleBiObservable<V extends LifeOwner, T>
implements BiObservable<V, T> {
    private final IModel<T> supplier;
    private final InternalObserver<V, T> observer;
    private final boolean io;
    private static Executor executor;

    private SimpleBiObservable(IModel<T> supplier, V owner) {
        this(supplier, owner, false);
    }

    private SimpleBiObservable(IModel<T> supplier, V owner, boolean io) {
        this.supplier = supplier;
        this.io = io;
        this.observer = new InternalObserver((LifeOwner)owner, null);
    }

    public static void setExecutor(Executor executor) {
        SimpleBiObservable.executor = executor;
    }

    private static void defaultExecutor() {
        executor = new ThreadPoolExecutor(0, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public final void observe(BiObserver<V, T> biObserver) {
        this.observer.observer(biObserver);
        if (this.io) {
            if (executor == null) {
                SimpleBiObservable.defaultExecutor();
            }
            executor.execute(() -> {
                try {
                    this.observer.setCloseable(this.supplier.accept(this.observer));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else {
            try {
                this.observer.setCloseable(this.supplier.accept(this.observer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <V extends LifeOwner, T> BiObservable<V, T> subject(V v, IModel<T> supplier) {
        return new SimpleBiObservable<V, T>(supplier, v);
    }

    public static <V extends LifeOwner, T> BiObservable<V, T> subject(V v, boolean io, IModel<T> supplier) {
        return new SimpleBiObservable<V, T>(supplier, v, io);
    }

    private static class InternalObserver<V extends LifeOwner, T>
    extends BaseModel<T>
    implements Observer<T> {
        private BiObserver<V, T> mBiObserver;
        private final WeakReference<V> ownerWeakReference;

        private InternalObserver(V owner) {
            this.ownerWeakReference = new WeakReference<V>(owner);
        }

        void observer(BiObserver<V, T> observer) {
            this.mBiObserver = observer;
            this.observe((LifecycleOwner)this.ownerWeakReference.get(), this);
        }

        public void onChanged(T t) {
            LifeOwner owner = (LifeOwner)this.ownerWeakReference.get();
            if (this.mBiObserver != null && owner != null) {
                this.mBiObserver.onChanged(owner, t);
            }
        }

        @Override
        protected void onInactive() {
            super.onInactive();
            this.removeObserver(this);
            this.mBiObserver = null;
        }

        /* synthetic */ InternalObserver(LifeOwner x0, 1 x1) {
            this(x0);
        }
    }
}

