package cn.keayuan.ui.vm;

import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Created by keayuan on 2020/11/25.
 *
 * @author keayuan
 */
public class SimpleBiObservable<V extends LifeOwner, T> implements BiObservable<V, T> {
    private final IModel<T> supplier;
    private final InternalObserver<V, T> observer;
    private final boolean io;

    private static Executor executor;

    private SimpleBiObservable(IModel<T> supplier, V owner) {
        this(supplier, owner, false);
    }

    private SimpleBiObservable(IModel<T> supplier, V owner, boolean io) {
        this.supplier = supplier;
        this.io = io;
        observer = new InternalObserver<>(owner);
    }

    public static void setExecutor(Executor executor) {
        SimpleBiObservable.executor = executor;
    }

    private static void defaultExecutor() {
        executor = new ThreadPoolExecutor(0, 10, 10, TimeUnit.SECONDS, new LinkedBlockingQueue<>());
    }

    @Override
    public final void observe(BiObserver<V, T> biObserver) {
        observer.observer(biObserver);
        if (io) {
            if (executor == null) {
                defaultExecutor();
            }
            executor.execute(() -> {
                try {
                    observer.setCloseable(supplier.accept(observer));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else {
            try {
                observer.setCloseable(supplier.accept(observer));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <V extends LifeOwner, T> BiObservable<V, T> subject(V v, IModel<T> supplier) {
        return new SimpleBiObservable<>(supplier, v);
    }

    public static <V extends LifeOwner, T> BiObservable<V, T> subject(V v, boolean io, IModel<T> supplier) {
        return new SimpleBiObservable<>(supplier, v, io);
    }

    private static class InternalObserver<V extends LifeOwner, T> extends BaseModel<T> implements Observer<T> {
        private BiObserver<V, T> mBiObserver;
        private final WeakReference<V> ownerWeakReference;

        private InternalObserver(V owner) {
            ownerWeakReference = new WeakReference<>(owner);
        }

        void observer(BiObserver<V, T> observer) {
            mBiObserver = observer;
            observe(ownerWeakReference.get(), this);
        }

        @Override
        public void onChanged(T t) {
            V owner = ownerWeakReference.get();
            if (mBiObserver != null && owner != null) {
                mBiObserver.onChanged(owner, t);
            }
        }

        @Override
        protected void onInactive() {
            super.onInactive();
            removeObserver(this);
            mBiObserver = null;
        }
    }
}
