package cn.keayuan.ui.vm;

import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import cn.keayuan.ui.UtilX;

/**
 * Created by keayuan on 2021/6/23.
 *
 * @author keayuan
 */
public interface IViewModel<V extends BaseVM> {
    default V getViewModel(ViewModelStoreOwner store) {
        int index = getViewModelIndex();
        if (index < 0) throw new IllegalStateException("getViewModelIndex " + index);
        Class<V> clazz = UtilX.getGenericTypeClass(getClass(), index, BaseVM.class);
        if (clazz == null) return null;
        return new ViewModelProvider(store).get(clazz);
    }

    default int getViewModelIndex() {
        return 0;
    }
}
