package cn.keayuan.ui.vm;

import android.os.Handler;
import android.os.Looper;

import androidx.lifecycle.ViewModel;

/**
 * Created by keayuan on 2021/6/21.
 *
 * @author keayuan
 */
public class BaseVM extends ViewModel {
    private Handler mainHandler;

    protected void post(long delay, Runnable runnable) {
        if (mainHandler == null) {
            mainHandler = new Handler(Looper.getMainLooper());
        }
        mainHandler.postDelayed(runnable, delay);
    }

    protected void removeCallback(Runnable runnable) {
        if (mainHandler != null) {
            mainHandler.removeCallbacks(runnable);
        }
    }

    protected boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    @Override
    protected void onCleared() {
        if (mainHandler != null) {
            mainHandler.removeCallbacksAndMessages(null);
        }
    }
}
