package cn.keayuan.ui.vm;

import java.io.Closeable;

import androidx.lifecycle.LiveData;
import cn.keayuan.util.IOUtils;

/**
 * Created by keayuan on 2020/4/3.
 *
 * @author keayuan
 */
public class BaseModel<T> extends LiveData<T> {
    private Closeable closeable;
    private String name;

    public BaseModel() {
    }

    public BaseModel(String name) {
        this.name = name;
    }

    public BaseModel(String name, T value) {
        this.name = name;
        post(value);
    }

    public void post(T value) {
        super.postValue(value);
    }

    @Override
    public void postValue(T value) {
        super.postValue(value);
    }

    public void setCloseable(Closeable closeable) {
        this.closeable = closeable;
    }

    @Override
    protected void onInactive() {
        IOUtils.closeQuietly(closeable);
        closeable = null;
    }
}
