package cn.keayuan.ui.adapter;

import android.view.View;
import android.widget.AbsListView;

import androidx.viewbinding.ViewBinding;

/**
 * Created by keayuan on 2021/2/3.
 *
 * @author keayuan
 */
public class VBHolder<T, V extends ViewBinding> extends VHolder<T> {
    public final V vb;

    public VBHolder(V vb) {
        this(vb, null);
    }

    VBHolder(V vb, View view) {
        super(view == null ? vb.getRoot() : view);
        this.vb = vb;
        rootView().setLayoutParams(new AbsListView.LayoutParams(-1, -2));
    }

    private int count;

    void setCount(int count) {
        this.count = count;
    }

    public boolean isLast() {
        return position() == count - 1;
    }
}
