package cn.keayuan.ui.adapter;

import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import cn.keayuan.util.function.BiFunction;

/**
 * Created by keayuan on 2021/2/5.
 *
 * @author keayuan
 */
public class IAdapter<T, VH extends IHolder<T>> extends RecyclerView.Adapter<IAdapter.VHInternal<T, VH>> implements IViewAdapter<T, VH> {

    private final AdapterInternal<T, VH> internal;

    public IAdapter() {
        this(null);
    }

    public IAdapter(int layoutId) {
        this(builder(layoutId));
    }

    protected IAdapter(IViewAdapter.Builder<T, VH, ? extends IViewAdapter<T, VH>> builder) {
        internal = new AdapterInternal<>(builder);
    }

    @NonNull
    @Override
    public final VHInternal<T, VH> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new VHInternal<>(onCreateHolder(parent, viewType));
    }

    @Override
    public final void onBindViewHolder(@NonNull VHInternal<T, VH> holder, int position) {
        internal.bindHolder(this, holder.holder, position);
        onBindHolder(holder.holder);
    }

    @Override
    public final int getItemCount() {
        return getTotalCount();
    }

    @Override
    public int getItemViewType(int position) {
        if (internal.viewTypeProvider != null) {
            return internal.viewTypeProvider.apply(position);
        }
        return super.getItemViewType(position);
    }

    @Override
    public final AdapterInternal<T, VH> getInternal() {
        return internal;
    }

    public static <B, VH extends IHolder<B>> Builder<B, VH> builder(int layoutId) {
        return new Builder<>(layoutId);
    }

    public static <B, VH extends IHolder<B>> Builder<B, VH> builder(BiFunction<ViewGroup, Integer, VH> vhProvider) {
        return new Builder<>(vhProvider);
    }

    protected static class VHInternal<B, VH extends IHolder<B>> extends RecyclerView.ViewHolder {
        VH holder;

        public VHInternal(@NonNull VH holder) {
            super(holder.rootView());
            this.holder = holder;
        }
    }

    public static class Builder<B, VH extends IHolder<B>> extends IViewAdapter.Builder<B, VH, IAdapter<B, VH>> {

        public Builder(int layoutId) {
            super(layoutId);
        }

        public Builder(BiFunction<ViewGroup, Integer, VH> vhProvider) {
            super(vhProvider);
        }

        @Override
        public IAdapter<B, VH> build() {
            return new IAdapter<>(this);
        }
    }
}
