package cn.keayuan.ui;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * Created by keayuan on 2023.8.15.
 *
 * @author keayuan
 */
public class UtilX {

    public static <C> Class<C> getGenericTypeClass(Class<?> clazz, int index, Class<?> parent) {
        if (clazz == Object.class || index < 0 || parent == null) return null;
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType) type;
            if (pType.getActualTypeArguments().length > index) {
                Type actualType = pType.getActualTypeArguments()[index];
                Class<?> temp = null;
                if (actualType instanceof Class) {
                    temp = (Class<?>) actualType;
                }
                if (actualType instanceof ParameterizedType) {
                    temp = (Class<?>) ((ParameterizedType) actualType).getRawType();
                }
                if (temp != null && parent.isAssignableFrom(temp)) {
                    return (Class<C>) temp;
                }
            }
        }
        return getGenericTypeClass(clazz.getSuperclass(), index, parent);
    }
}
