package cn.keayuan.ui;

import android.view.LayoutInflater;
import android.view.ViewGroup;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import androidx.viewbinding.ViewBinding;
import cn.keayuan.util.log.Logger;

/**
 * Created by keayuan on 2021/6/23.
 *
 * @author keayuan
 */
public interface IViewBind<V extends ViewBinding> {

    /**
     * 获取V在当前类中的泛型位置
     *
     * @return ret >= 0 && ret < 当前类的泛型数量
     */
    default int getViewBindIndex() {
        return 0;
    }

    /**
     * 获取ViewBinding
     */
    default V getViewBinding() {
        int index = getViewBindIndex();
        if (index < 0) throw new IllegalStateException("getViewBindIndex " + index);
        Class<V> clazz = UtilX.getGenericTypeClass(getClass(), index, ViewBinding.class);
        if (clazz == null) return null;
        return getViewBinding(clazz, getViewParent(), getLayoutInflater(), true);
    }

    @SuppressWarnings("unchecked")
    static <V> V getViewBinding(Class<V> vbClass, ViewGroup parent, LayoutInflater inflater, boolean attachToParent) {
        try {
            if (parent == null) {
                Method method = vbClass.getMethod("inflate", LayoutInflater.class);
                return (V) method.invoke(null, inflater);
            }
            Method method = vbClass.getMethod("inflate", LayoutInflater.class, ViewGroup.class, boolean.class);
            return (V) method.invoke(null, inflater, parent, attachToParent);
        } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
            Logger.e("IViewBind", e.getMessage(), e);
        }
        return null;
    }

    LayoutInflater getLayoutInflater();

    /**
     * 获取view的父view
     *
     * @return null则不会被添加到parent中
     */
    default ViewGroup getViewParent() {
        return null;
    }

}
