package cn.keayuan.ui;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

/**
 * Created by sskbskdrin on 2022/5/11.
 *
 * @author sskbskdrin
 */
public interface IRecyclerView {
    RecyclerView getRecyclerView();

    default void setLayoutManager(Layout layout) {
        setLayoutManager(layout, true);
    }

    default void setLayoutManager(Layout layout, boolean isVertical) {
        setLayoutManager(layout, isVertical, 0);
    }

    default void setLayoutManager(Layout layout, boolean isVertical, int count) {
        setLayoutManager(layout, isVertical, count, false);
    }

    default void setLayoutManager(Layout layout, boolean isVertical, int count, boolean reverse) {
        RecyclerView view = getRecyclerView();
        int or = isVertical ? RecyclerView.VERTICAL : RecyclerView.HORIZONTAL;
        switch (layout) {
            case STAGGERED:
                view.setLayoutManager(new StaggeredGridLayoutManager(count, or));
                break;
            case GRID:
                view.setLayoutManager(new GridLayoutManager(view.getContext(), count, or, reverse));
                break;
            case LINEAR:
                view.setLayoutManager(new LinearLayoutManager(view.getContext(), or, reverse));
                break;
            default:
        }
    }

    default void setAdapter(RecyclerView.Adapter adapter) {
        getRecyclerView().setAdapter(adapter);
    }

    default <T extends RecyclerView.Adapter> T getAdapter() {
        return (T) getRecyclerView().getAdapter();
    }

    default void addItemDecoration(RecyclerView.ItemDecoration decoration) {
        getRecyclerView().addItemDecoration(decoration);
    }

    enum Layout {
        LINEAR,
        GRID,
        STAGGERED
    }
}
