/*
 * Decompiled with CFR 0.152.
 */
package cn.kanejin.olla.support.tx;

import cn.kanejin.olla.response.ServiceResult;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;

public class ServiceTransactionInterceptor
extends TransactionInterceptor {
    private static final long serialVersionUID = 124054498346164726L;

    public ServiceTransactionInterceptor() {
    }

    public ServiceTransactionInterceptor(PlatformTransactionManager ptm, Properties attributes) {
        super(ptm, attributes);
    }

    public ServiceTransactionInterceptor(PlatformTransactionManager ptm, TransactionAttributeSource tas) {
        super(ptm, tas);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class targetClass = invocation.getThis() != null ? AopUtils.getTargetClass((Object)invocation.getThis()) : null;
        TransactionAttribute txAttr = this.getTransactionAttributeSource().getTransactionAttribute(invocation.getMethod(), targetClass);
        PlatformTransactionManager tm = this.determineTransactionManager(txAttr);
        String joinpointIdentification = this.methodIdentification(invocation.getMethod(), targetClass);
        if (txAttr == null || !(tm instanceof CallbackPreferringPlatformTransactionManager)) {
            TransactionAspectSupport.TransactionInfo txInfo = this.createTransactionIfNecessary(tm, txAttr, joinpointIdentification);
            Object retVal = null;
            try {
                retVal = invocation.proceed();
                this.completeTransactionAfterReturning(txInfo, (ServiceResult)retVal);
            }
            catch (Throwable ex) {
                this.completeTransactionAfterThrowing(txInfo, ex);
                throw ex;
            }
            finally {
                this.cleanupTransactionInfo(txInfo);
            }
            return retVal;
        }
        return super.invoke(invocation);
    }

    protected void completeTransactionAfterReturning(TransactionAspectSupport.TransactionInfo txInfo, ServiceResult<?> result) {
        if (txInfo != null && txInfo.hasTransaction()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Completing transaction for [" + txInfo.getJoinpointIdentification() + "]"));
            }
            if (result == null || !result.isOk()) {
                txInfo.getTransactionManager().rollback(txInfo.getTransactionStatus());
            } else {
                txInfo.getTransactionManager().commit(txInfo.getTransactionStatus());
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getTransactionManagerBeanName());
        oos.writeObject(this.getTransactionManager());
        oos.writeObject(this.getTransactionAttributeSource());
        oos.writeObject(this.getBeanFactory());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.setTransactionManagerBeanName((String)ois.readObject());
        this.setTransactionManager((PlatformTransactionManager)ois.readObject());
        this.setTransactionAttributeSource((TransactionAttributeSource)ois.readObject());
        this.setBeanFactory((BeanFactory)ois.readObject());
    }
}

