/*
 * Decompiled with CFR 0.152.
 */
package cn.kanejin.olla.support.query;

import cn.kanejin.olla.request.QueryRequest;
import cn.kanejin.olla.response.QueryResult;
import cn.kanejin.olla.support.query.QuerylistAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuerylistAdapter
implements QuerylistAdapter {
    private static Logger log = LoggerFactory.getLogger(AbstractQuerylistAdapter.class);
    private String sqlmap;
    private int defaultNumPerPage = 10;
    private int maxNumPerPage = 100;
    private String defaultSort;

    @Override
    public <E> QueryResult<E> queryList(QueryRequest info, Integer page, Integer limit) {
        QueryResult result = new QueryResult();
        int total = this.count(info);
        if (page == null || page <= 0) {
            page = 1;
        }
        if (limit == null || limit <= 0) {
            limit = this.getDefaultNumPerPage();
        }
        if (limit > this.getMaxNumPerPage()) {
            limit = this.getMaxNumPerPage();
        }
        if (page > 1 && (page - 1) * limit > total - 1) {
            page = (total - 1) / limit + 1;
        }
        result.setPaging(page.intValue(), limit.intValue(), total);
        if (total == 0) {
            result.setList(new ArrayList());
            return result;
        }
        List<E> list = this.query(info, page, limit);
        result.setList(list);
        return result;
    }

    protected abstract <E> List<E> selectList(String var1, Map<String, Object> var2);

    protected abstract Integer selectCount(String var1, Map<String, Object> var2);

    @Override
    public int count(QueryRequest info) {
        log.debug("Start to count total of list[{}]", (Object)this.getCountSqlmap());
        return this.selectCount(this.getCountSqlmap(), info.getParameters());
    }

    @Override
    public <E> List<E> queryTop(QueryRequest info, Integer top) {
        if (top == null || top <= 0) {
            top = this.getDefaultNumPerPage();
        }
        if (top > this.getMaxNumPerPage()) {
            top = this.getMaxNumPerPage();
        }
        return this.query(info, 1, top);
    }

    private <E> List<E> query(QueryRequest info, Integer page, Integer limit) {
        log.debug("Start to query top list[{}]", (Object)this.getSqlmap());
        String orderBy = info.getOrderBy();
        if (orderBy == null || orderBy.isEmpty()) {
            orderBy = this.getDefaultSort();
            log.debug("The default sort '{}' was  set.", (Object)orderBy);
        }
        return this.selectList(this.getSqlmap(), this.mixOrderAndPagingParams(info.getParameters(), orderBy, page, limit));
    }

    private Map<String, Object> mixOrderAndPagingParams(Map<String, Object> params, String orderBy, int page, int limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (params != null) {
            map.putAll(params);
        }
        map.put("order_by", orderBy);
        map.put("start_num", (page - 1) * limit);
        map.put("limit_num", limit);
        map.put("end_num", page * limit);
        return map;
    }

    public String getSqlmap() {
        return this.sqlmap;
    }

    public void setSqlmap(String sqlmap) {
        this.sqlmap = sqlmap;
    }

    public String getCountSqlmap() {
        return this.getSqlmap() + "Count";
    }

    public int getDefaultNumPerPage() {
        return this.defaultNumPerPage;
    }

    public void setDefaultNumPerPage(int defaultNumPerPage) {
        this.defaultNumPerPage = defaultNumPerPage;
    }

    public int getMaxNumPerPage() {
        return this.maxNumPerPage;
    }

    public void setMaxNumPerPage(int maxNumPerPage) {
        this.maxNumPerPage = maxNumPerPage;
    }

    public String getDefaultSort() {
        return this.defaultSort;
    }

    public void setDefaultSort(String defaultSort) {
        this.defaultSort = defaultSort;
    }
}

