/*
 * Decompiled with CFR 0.152.
 */
package cn.kanejin.olla.server.interceptor;

import cn.kanejin.olla.ServiceContext;
import cn.kanejin.olla.ServiceContextHolder;
import cn.kanejin.olla.annotation.Cached;
import cn.kanejin.olla.annotation.ServiceGuard;
import cn.kanejin.olla.response.FailureResult;
import cn.kanejin.olla.response.ServiceResult;
import cn.kanejin.olla.response.ServiceResultStatus;
import cn.kanejin.olla.server.interceptor.ServiceCacheStorage;
import cn.kanejin.olla.server.util.MD5Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component(value="serviceInterceptor")
@Aspect
public class ServiceInterceptor {
    private static Logger log = LoggerFactory.getLogger(ServiceInterceptor.class);
    @Autowired
    private ApplicationContext appContext;
    @Autowired(required=false)
    @Qualifier(value="serviceCacheStorage")
    private ServiceCacheStorage serviceCacheStorage;

    private static String convertArgToString(Object arg) {
        if (arg == null) {
            return null;
        }
        if (!arg.getClass().isArray()) {
            return arg.toString();
        }
        StringBuilder result = new StringBuilder("[");
        Object[] subArgs = (Object[])arg;
        for (int j = 0; j < subArgs.length; ++j) {
            if (j != 0) {
                result.append(",");
            }
            result.append(ServiceInterceptor.convertArgToString(subArgs[j]));
        }
        return result.append("]").toString();
    }

    @Around(value="execution(cn.kanejin.olla.response.ServiceResult *..*ServiceImpl.*(..))")
    public Object aroundService(ProceedingJoinPoint pjp) throws Throwable {
        ServiceGuard sg;
        boolean isCachedService = this.isCachedMethod(pjp);
        String cacheKey = null;
        ServiceResult<?> retVal = null;
        if (this.serviceCacheStorage != null && isCachedService) {
            boolean useCache;
            cacheKey = this.getCacheKey(pjp);
            ServiceContext context = ServiceContextHolder.get();
            boolean bl = useCache = context == null || context.isUseCache();
            if (useCache && (retVal = this.serviceCacheStorage.getResult(cacheKey)) != null) {
                return retVal;
            }
        }
        if ((sg = this.getServiceGuard(pjp)) != null) {
            retVal = this.proceedGuard(sg, pjp);
            if (retVal == null || retVal.isOk()) {
                retVal = this.proceedServiceMethod(pjp);
            }
        } else {
            retVal = this.proceedServiceMethod(pjp);
        }
        if (this.serviceCacheStorage != null && isCachedService && cacheKey != null && !cacheKey.isEmpty() && retVal != null && retVal.isOk()) {
            this.serviceCacheStorage.putResult(cacheKey, retVal);
        }
        return retVal;
    }

    private ServiceResult<?> proceedGuard(ServiceGuard sg, ProceedingJoinPoint pjp) {
        String[] guardBeanNames = sg.value();
        if (guardBeanNames == null || guardBeanNames.length == 0) {
            return null;
        }
        for (String gbn : guardBeanNames) {
            ServiceResult<?> r = this.proceedOneGuard(gbn, pjp);
            if (r == null || r.isOk()) continue;
            return r;
        }
        return null;
    }

    private ServiceResult<?> proceedOneGuard(String guardBeanName, ProceedingJoinPoint pjp) {
        Object gb = this.appContext.getBean(guardBeanName);
        if (gb == null) {
            return null;
        }
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        Method guardMethod = ClassUtils.getMostSpecificMethod((Method)method, gb.getClass());
        if ((guardMethod = BridgeMethodResolver.findBridgedMethod((Method)guardMethod)) == null) {
            return null;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Proceeding Service Guard [{}]", (Object)guardMethod.getName());
            }
            return (ServiceResult)guardMethod.invoke(gb, pjp.getArgs());
        }
        catch (Throwable t) {
            log.error("Service Error", t);
            return new FailureResult(ServiceResultStatus.ERROR, "Service Error");
        }
    }

    private ServiceResult<?> proceedServiceMethod(ProceedingJoinPoint pjp) {
        ServiceResult retVal = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Proceeding Service Method [{}]", (Object)pjp.getSignature());
            }
            retVal = (ServiceResult)pjp.proceed();
        }
        catch (Throwable t) {
            log.error("Service Error", t);
            retVal = new FailureResult(ServiceResultStatus.ERROR, "Service Error");
        }
        return retVal;
    }

    @After(value="execution(cn.kanejin.olla.response.ServiceResult *..*ServiceImpl.*(..))")
    public void cleanContext() throws Throwable {
        log.debug("Cleaning Service Context");
        ServiceContextHolder.remove();
    }

    private String getCacheKey(ProceedingJoinPoint pjp) {
        StringBuilder key = new StringBuilder(pjp.getSignature().toString());
        Object[] args = pjp.getArgs();
        key.append("{");
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (i != 0) {
                    key.append(",");
                }
                key.append(ServiceInterceptor.convertArgToString(arg));
            }
        }
        key.append("}");
        String result = "_sc_" + (key.length() > 200 ? MD5Utils.md5(key.toString()) : key.toString());
        log.debug("Generate Cache key [{}] for [{}]", (Object)result, (Object)key);
        return result;
    }

    private ServiceGuard getServiceGuard(ProceedingJoinPoint pjp) {
        Class targetClass;
        Class clazz = targetClass = pjp.getThis() != null ? AopUtils.getTargetClass((Object)pjp.getThis()) : null;
        if (targetClass == null) {
            return null;
        }
        ServiceGuard guard = targetClass.getAnnotation(ServiceGuard.class);
        if (guard == null) {
            Annotation metaAnn;
            Annotation[] annotationArray = targetClass.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (guard = (metaAnn = annotationArray[i]).annotationType().getAnnotation(ServiceGuard.class)) == null; ++i) {
            }
        }
        return guard;
    }

    private boolean isCachedMethod(ProceedingJoinPoint pjp) {
        int n;
        Class targetClass;
        Class clazz = targetClass = pjp.getThis() != null ? AopUtils.getTargetClass((Object)pjp.getThis()) : null;
        if (targetClass == null) {
            return false;
        }
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        Cached ann = method.getAnnotation(Cached.class);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] annotationArray = method.getAnnotations();
            int n2 = annotationArray.length;
            for (n = 0; n < n2 && (ann = (metaAnn = annotationArray[n]).annotationType().getAnnotation(Cached.class)) == null; ++n) {
            }
        }
        if (ann != null) {
            return true;
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
        ann = (specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod)).getAnnotation(Cached.class);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] annotationArray = specificMethod.getAnnotations();
            n = annotationArray.length;
            for (int i = 0; i < n && (ann = (metaAnn = annotationArray[i]).annotationType().getAnnotation(Cached.class)) == null; ++i) {
            }
        }
        return ann != null;
    }
}

