/*
 * Decompiled with CFR 0.152.
 */
package cn.kanejin.olla.request;

import cn.kanejin.olla.ServiceContext;
import cn.kanejin.olla.request.RequesterLevel;

public class PermissionUtil {
    public static boolean isAnonymous(ServiceContext context) {
        return context == null || context.getRequester() == null || context.getRequester().getLevel() == null || context.getRequester().getLevel().equals((Object)RequesterLevel.ANONYMOUS);
    }

    public static boolean isUser(ServiceContext context) {
        if (context == null || context.getRequester() == null || context.getRequester().getLevel() == null) {
            return false;
        }
        return context.getRequester().getLevel().equals((Object)RequesterLevel.USER);
    }

    public static boolean isUserOrHigher(ServiceContext context) {
        return PermissionUtil.isUser(context) || PermissionUtil.isAdmin(context) || PermissionUtil.isSystem(context);
    }

    public static boolean isAdmin(ServiceContext context) {
        if (context == null || context.getRequester() == null || context.getRequester().getLevel() == null) {
            return false;
        }
        return context.getRequester().getLevel().equals((Object)RequesterLevel.ADMIN);
    }

    public static boolean isAdminOrHigher(ServiceContext context) {
        return PermissionUtil.isAdmin(context) || PermissionUtil.isSystem(context);
    }

    public static boolean isSystem(ServiceContext context) {
        if (context == null || context.getRequester() == null || context.getRequester().getLevel() == null) {
            return false;
        }
        return context.getRequester().getLevel().equals((Object)RequesterLevel.SYSTEM);
    }
}

