/*
 * Decompiled with CFR 0.152.
 */
package cn.kanejin.exts.spring.config;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;

public class EncryptPropertyPlaceholderGenerator {
    private static final String DES = "DES";

    public static void main(String[] args) {
        String key = args[0];
        String src = args[1];
        EncryptPropertyPlaceholderGenerator gen = new EncryptPropertyPlaceholderGenerator();
        String encString = gen.encryptString(src, key);
        System.out.println("DES Key = " + key);
        System.out.println(String.format("[%s] -> [<*>%s]", src, encString));
    }

    private String encryptString(String srcString, String key) {
        try {
            return Base64.encodeBase64String((byte[])EncryptPropertyPlaceholderGenerator.encrypt(srcString.getBytes("UTF-8"), key.getBytes()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        Cipher cipher = Cipher.getInstance(DES);
        cipher.init(1, (Key)EncryptPropertyPlaceholderGenerator.generateSecretKey(key), sr);
        return cipher.doFinal(data);
    }

    private static SecretKey generateSecretKey(byte[] key) throws Exception {
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        return keyFactory.generateSecret(dks);
    }
}

