/*
 * Decompiled with CFR 0.152.
 */
package cn.kanejin.exts.spring.config;

import cn.kanejin.commons.util.StringUtils;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class EncryptPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private String systemPropertyDesKeyName;
    private String encryptedValuePrefix = "<*>";
    private static final String DES = "DES";

    public void setSystemPropertyDesKeyName(String systemPropertyDesKeyName) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)systemPropertyDesKeyName)) {
            throw new IllegalArgumentException("System Property name of DES key is required");
        }
        this.systemPropertyDesKeyName = systemPropertyDesKeyName;
    }

    public void setEncryptedValuePrefix(String encryptedValuePrefix) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)encryptedValuePrefix)) {
            throw new IllegalArgumentException("Prefix of Encrypted Value is required");
        }
        this.encryptedValuePrefix = encryptedValuePrefix;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        this.decryptProperties(props);
        super.processProperties(beanFactory, props);
    }

    private void decryptProperties(Properties props) {
        if (props == null) {
            return;
        }
        String desKey = System.getProperty(this.systemPropertyDesKeyName);
        if (StringUtils.isBlank((String)desKey)) {
            return;
        }
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            if (StringUtils.isBlank((String)value) || !value.startsWith(this.encryptedValuePrefix)) continue;
            String newValue = this.decryptString(value.substring(this.encryptedValuePrefix.length()), desKey);
            props.setProperty(key, newValue);
        }
    }

    private String decryptString(String encString, String key) {
        try {
            return new String(EncryptPropertyPlaceholderConfigurer.decrypt(Base64.decodeBase64((String)encString), key.getBytes()), "UTF8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static SecretKey generateSecretKey(byte[] key) throws Exception {
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        return keyFactory.generateSecret(dks);
    }

    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        Cipher cipher = Cipher.getInstance(DES);
        cipher.init(2, (Key)EncryptPropertyPlaceholderConfigurer.generateSecretKey(key), sr);
        return cipher.doFinal(data);
    }
}

