package cn.kanejin.exts.spring.config;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import java.security.SecureRandom;

public class EncryptPropertyPlaceholderGenerator {

    public static void main(String[] args) {

        String key = args[0];
        String src = args[1];

        EncryptPropertyPlaceholderGenerator gen = new EncryptPropertyPlaceholderGenerator();

        String encString = gen.encryptString(src, key);

        System.out.println("DES Key = " + key);
        System.out.println(String.format("[%s] -> [<*>%s]", src, encString));
    }

    private String encryptString(String srcString, String key) {
        try {
            return Base64.encodeBase64String(encrypt(srcString.getBytes("UTF-8"), key.getBytes()));
        } catch (Exception e) {
        }

        return null;
    }

    private static final String DES = "DES";

    /**
     * Description 根据键值进行加密
     *
     * @param data
     * @param key  加密键byte数组
     * @return
     * @throws Exception
     */
    private static byte[] encrypt(byte[] data, byte[] key) throws Exception {

        // 生成一个可信任的随机数源
        SecureRandom sr = new SecureRandom();

        // Cipher对象实际完成加密操作
        Cipher cipher = Cipher.getInstance(DES);

        // 用密钥初始化Cipher对象
        cipher.init(Cipher.ENCRYPT_MODE, generateSecretKey(key), sr);

        return cipher.doFinal(data);
    }

    private static SecretKey generateSecretKey(byte[] key) throws Exception {
        // 从原始密钥数据创建DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(key);

        // 创建一个密钥工厂，然后用它把DESKeySpec转换成SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        return keyFactory.generateSecret(dks);
    }

}
