package cn.kanejin.exts.spring.config;

import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Properties;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

import static cn.kanejin.commons.util.StringUtils.isBlank;


public class EncryptPropertyPlaceholderConfigurer extends PropertyPlaceholderConfigurer {

    private String systemPropertyDesKeyName;

    private String encryptedValuePrefix = "<*>";


    public void setSystemPropertyDesKeyName(String systemPropertyDesKeyName) throws IllegalArgumentException {
        if (isBlank(systemPropertyDesKeyName)) {
            throw new IllegalArgumentException("System Property name of DES key is required");
        }

        this.systemPropertyDesKeyName = systemPropertyDesKeyName;
    }

    public void setEncryptedValuePrefix(String encryptedValuePrefix) throws IllegalArgumentException {
        if (isBlank(encryptedValuePrefix)) {
            throw new IllegalArgumentException("Prefix of Encrypted Value is required");
        }

        this.encryptedValuePrefix = encryptedValuePrefix;
    }

    @Override
    protected void processProperties(
            ConfigurableListableBeanFactory beanFactory, Properties props)
            throws BeansException {

        decryptProperties(props);

        super.processProperties(beanFactory, props);
    }

    private void decryptProperties(Properties props) {

        if (props == null)
            return;

        String desKey = System.getProperty(systemPropertyDesKeyName);

        if (isBlank(desKey))
            return;

        for (Enumeration<Object> keys = props.keys(); keys.hasMoreElements(); ) {

            String key = (String) keys.nextElement();

            String value = props.getProperty(key);

            if (isBlank(value))
                continue;

            if (value.startsWith(encryptedValuePrefix)) {
                String newValue = decryptString(value.substring(encryptedValuePrefix.length()), desKey);
                props.setProperty(key, newValue);
            }
        }
    }

    private String decryptString(String encString, String key) {
        try {
            return new String(decrypt(Base64.decodeBase64(encString), key.getBytes()), "UTF8");
        } catch (Exception e) {
        }
        return null;
    }

    private static final String DES = "DES";

    private static SecretKey generateSecretKey(byte[] key) throws Exception {
        // 从原始密钥数据创建DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(key);

        // 创建一个密钥工厂，然后用它把DESKeySpec转换成SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        return keyFactory.generateSecret(dks);
    }


    /**
     * Description 根据键值进行解密
     *
     * @param data
     * @param key  加密键byte数组
     * @return
     * @throws Exception
     */
    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        // 生成一个可信任的随机数源
        SecureRandom sr = new SecureRandom();

        // Cipher对象实际完成解密操作
        Cipher cipher = Cipher.getInstance(DES);

        // 用密钥初始化Cipher对象
        cipher.init(Cipher.DECRYPT_MODE, generateSecretKey(key), sr);

        return cipher.doFinal(data);
    }

}