/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.ioc.conversion;

import cn.k7g.alloy.annotation.AlloyContent;
import cn.k7g.alloy.exception.AlloyMessageException;
import cn.k7g.alloy.model.AlloyContentHold;
import org.springframework.boot.autoconfigure.web.format.DateTimeFormatters;
import org.springframework.boot.autoconfigure.web.format.WebConversionService;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AlloyConversionService
extends WebConversionService {
    public AlloyConversionService(DateTimeFormatters dateTimeFormatters) {
        super(dateTimeFormatters);
    }

    @Nullable
    public GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.hasAnnotation(AlloyContent.class)) {
            targetType = new TypeDescriptor(ResolvableType.forClass(AlloyContentHold.class), AlloyContentHold.class, targetType.getAnnotations());
        }
        return super.getConverter(sourceType, targetType);
    }

    @Nullable
    public Object convert(@Nullable Object source, @Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull((Object)targetType, (String)"Target type to convert to cannot be null");
        if (sourceType == null) {
            Assert.isTrue((source == null ? 1 : 0) != 0, (String)"Source must be [null] if source type == [null]");
            return this.handleResult(null, targetType, this.convertNullSource(null, targetType));
        }
        if (source != null && !sourceType.getObjectType().isInstance(source)) {
            throw new IllegalArgumentException("Source to convert from must be an instance of [" + sourceType + "]; instead it was a [" + source.getClass().getName() + "]");
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        if (converter != null) {
            Object result = this.ConversionUtils_invokeConverter(converter, source, sourceType, targetType);
            return this.handleResult(sourceType, targetType, result);
        }
        return this.handleConverterNotFound(source, sourceType, targetType);
    }

    Object ConversionUtils_invokeConverter(GenericConverter converter, @Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            Object result = converter.convert(source, sourceType, targetType);
            return this.handleResult(sourceType, targetType, result);
        }
        catch (AlloyMessageException | ConversionFailedException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex);
        }
    }

    @Nullable
    private Object handleResult(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType, @Nullable Object result) {
        if (result == null) {
            this.assertNotPrimitiveTargetType(sourceType, targetType);
        }
        return result;
    }

    private void assertNotPrimitiveTargetType(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.isPrimitive()) {
            throw new ConversionFailedException(sourceType, targetType, null, (Throwable)new IllegalArgumentException("A null value cannot be assigned to a primitive type"));
        }
    }

    @Nullable
    private Object handleConverterNotFound(@Nullable Object source, @Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            this.assertNotPrimitiveTargetType(sourceType, targetType);
            return null;
        }
        if ((sourceType == null || sourceType.isAssignableTo(targetType)) && targetType.getObjectType().isInstance(source)) {
            return source;
        }
        throw new ConverterNotFoundException(sourceType, targetType);
    }
}

