package cn.k7g.alloy.utils;

import java.util.function.Supplier;

public class Any {

    public static <T> T or(T origin, T defaultVal) {
        return origin != null ? origin : defaultVal;
    }

    public static <T,X extends Throwable> T or(T origin, Supplier<? extends X> exceptionSupplier) throws X {
        if (origin != null) {
            return origin;
        }
        throw exceptionSupplier.get();
    }

    public static <T> T orGet(T origin, Supplier<? extends T> other) {
        return origin != null ? origin : other.get();
    }

}
