package cn.k7g.alloy.core.objectmapper;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.util.Optional;

/**
 * 序列化时间扩展器
 * @author victor-wu
 * @date 2021/9/27 下午1:10
 */
public class TimestampSerializer extends JsonSerializer<Timestamp> {
    @Override
    public void serialize(Timestamp timestamp, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Long value = Optional.ofNullable(timestamp).map(v -> v.get()).orElse(null);
        if (value == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeNumber(value);
    }
}
