package cn.k7g.alloy.core.objectmapper;

import cn.k7g.alloy.model.SortOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;

/**
 * 序列化 SortOrder
 * @author victor-wu
 * @date 2021/9/27 下午1:10
 */
public class SortOrderSerializer extends JsonSerializer<SortOrder> {
    @Override
    public void serialize(SortOrder value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else {
            gen.writeNumber(value.longValue());
        }
    }
}
