package cn.k7g.alloy.autoconfiguration;


import org.springframework.context.annotation.Import;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 自动装配类
 * @author victor-wu
 * @date 2024年4月3日
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Import(AlloyAutoConfigurationSelector.class)
public @interface EnableAlloyAutoConfiguration {

    /**
     * 增强 ObjectMapper 配置
     */
    boolean enableEnhanceObjectMapper() default false;

    /**
     * 增强异常消息提示，将英文错误代码映射为中文,
     * 有两种方式实现：
     * <br/>
     * 方式1：<br/>
     *
     * 注意：如果遇到开启异常增强不生效的时候，可能是注册类冲突导致的
     * 需要全局检查一下项目中是否有 @RestControllerAdvice 或者 @ControllerAdvice，将其取消，交给 Alloy处理。
     *
     * 如果有额外的异常需要处理：可以通过实现 WebExceptionResponseHandler 处理， 下面是一段对于若依项目实现的代码例如：
     * <code>
     * @Component
     * public class ExceptionMsgHandler implements WebExceptionResponseHandler {
     *     @Override
     *     public Object handle(String msg, Exception e) {
     *         log.error("error: ", e);
     *         if (e instanceof ServiceException) {
     *             ServiceException e1 = (ServiceException) e;
     *             if (e1.getCode() == null) {
     *                 return AjaxResult.error(e1.getMessage());
     *             } else {
     *                 return AjaxResult.error(e1.getCode(), e1.getMessage());
     *             }
     *         }
     *         if (e instanceof BaseException) {
     *             return AjaxResult.error(e.getMessage());
     *         }
     *         return AjaxResult.error(msg);
     *     }
     * }
     * </code>
     * <br/>
     * <br/>
     * 方式2： <br/>
     * 保持自己的  @ControllerAdvice 实现，继承 EnhanceExceptionResponse，就可以实现原来的异常方式。
     *
     */
    boolean enableEnhanceExceptionMessage() default false;

    /**
     * 用于配置异常的中文提示信息的properties文件，且支持属性调用
     *
     * 此功能依赖enableEnhanceExceptionMessage中的实现
     *
     * 文件内容例如：
     * <code>
     * javax.security.auth.login.AccountExpiredException=登录失效了
     * org.springframework.web.bind.MissingServletRequestParameterException=缺少query参数{parameterName}
     * </code>
     * @return
     */
    String[] enhanceExceptionMessageProperties() default {"classpath:ExceptionMessages.properties"};

    /**
     * 启用忽略执行
     * 开启需要依赖 aspectjweaver
     *
     * <code>
 *             <dependency>
     *             <groupId>org.aspectj</groupId>
     *             <artifactId>aspectjweaver</artifactId>
     *         </dependency>
     * </code>
     */
    boolean enableIgnoreInvoke() default false;

    /**
     * 扫描 @MoldContent 注解所在的包
     * @return
     */
    String[] moldBasePackages() default {};


}
