package cn.k7g.alloy.annotation.verify;

import cn.k7g.alloy.validator.NotNullElementValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 验证是否存在null元素
 * 支持：Collection
 *
 * @author victor-wu
 * @date 2024/8/19 上午9:56
 */
@Target({ElementType.FIELD, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = NotNullElementValidator.class)
public @interface NotNullElement {
    Class<? extends Payload>[] payload() default { };
    Class[] groups() default {};
    String message() default "不得包含空元素";
}
